'use strict';
var directives = {};
directives.ngEnter = function() {
    return function(scope, elm, attrs) {
        elm.bind('keypress', function(e) {
            if (e.charCode === 13) {
                scope.$apply(attrs.ngEnter);
            }
        });
    };
}

directives.calendar = function(){
    return {
        require: 'ngModel'
        ,link: function(scope, element, attr, ngModel){
            var input = element;
            input.datetimepicker({
                dateFormat: "yy-mm-dd"
                ,timeFormat: "HH:mm:ss"
                ,onSelect: function(dateText){
                    scope.$apply(function(){
                        ngModel.$setViewValue(dateText);
                    });
                }
                ,onClose: function(dateText){
                    scope.$apply(function(){
                        ngModel.$setViewValue((dateText == '')? null: dateText);
                    });
                }
            });
        }
    }
}

directives.calendarButton = function(){
    return {
        link: function(scope, element, attr){
            element.on('click', function(){
                element.prev().datepicker('show');
            })
        }
    }
}

directives.sliderElement = function(){
    return {
        require: 'ngModel'
        ,scope: {
            ngModel: '='
        }
        ,controller: function($scope){
            $scope.$watch('ngModel', function(newValue){
                $scope.element.value = newValue;
            })
        }
        ,link: function(scope, element, attr, ngModel){
            scope.element = element;
            element.slider({
                min: -10
                ,max: 10
                ,value: scope.ngModel
                ,slide: function(event, ui){
                    scope.$apply(function(){
                        ngModel.$setViewValue(ui.value);
                    });
                }
            });
//
//            element.on('change', function(ev, ui){
//                console.log(ev, ui);
//                scope.$apply(function(){
//                    ngModel.$setViewValue(ev.value);
//                });
//            })
        }
    }
}